/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.i18n.net.GDKMessage;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.LocaleMapper;

public class CharEntityReference {
    private static final Set M_C_UNICODE_CHARSETS = new HashSet();
    private static final Map charEntity;
    private static final Map resCharEntities;

    private CharEntityReference() {
    }

    public static String escape(String string) {
        try {
            return CharEntityReference.escape(string, "WE8ISO8859P1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(GDKMessage.getMessage(5200));
        }
    }

    public static String escape(String string, String string2) throws UnsupportedEncodingException {
        return CharEntityReference.escape(string, string2, Form.NAMED_DECIMAL_NUMBER);
    }

    public static String escape(String string, String string2, Form form) throws UnsupportedEncodingException {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        String string3 = string2;
        String string4 = LocaleMapper.getOraCharacterSet(2, string2);
        if (string4 != null) {
            string3 = string4;
        }
        char c = '\u0000';
        Character c2 = null;
        String string5 = null;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            c2 = new Character(c);
            string5 = (String)resCharEntities.get(c2);
            if (string5 == null) {
                if (CharEntityReference.isValidIdentifier(c2.toString(), string3)) {
                    stringBuffer.append(c);
                    continue;
                }
                if (form == Form.NAMED_DECIMAL_NUMBER || form == Form.DECIMAL_NUMBER) {
                    stringBuffer.append("&#" + Integer.toString(c) + ";");
                    continue;
                }
                stringBuffer.append("&#x" + Integer.toHexString(c) + ";");
                continue;
            }
            if (form == Form.NAMED || form == Form.NAMED_DECIMAL_NUMBER || form == Form.NAMED_HEXADECIMAL_NUMBER) {
                stringBuffer.append(string5);
                continue;
            }
            if (form == Form.DECIMAL_NUMBER) {
                stringBuffer.append("&#" + Integer.toString(c) + ";");
                continue;
            }
            stringBuffer.append("&#x" + Integer.toHexString(c) + ";");
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    int n2 = string.indexOf(59, i + 1);
                    if (n2 < 0) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5203, (Object)string.substring(i + 1)));
                    }
                    if (string.charAt(i + 1) == '#') {
                        if (string.charAt(i + 2) == 'x') {
                            try {
                                stringBuffer.append((char)Integer.parseInt(string.substring(i + 3, n2), 16));
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException(GDKMessage.getMessage(5201, (Object)string.substring(i + 3, n2)));
                            }
                        } else {
                            try {
                                stringBuffer.append((char)Integer.parseInt(string.substring(i + 2, n2), 10));
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException(GDKMessage.getMessage(5202, (Object)string.substring(i + 2, n2)));
                            }
                        }
                    } else {
                        String string2 = (String)charEntity.get(string.substring(i + 1, n2));
                        if (string2 == null) {
                            throw new IllegalArgumentException(GDKMessage.getMessage(5203, (Object)string.substring(i + 1, n2)));
                        }
                        stringBuffer.append(string2.charAt(0));
                    }
                    i = n2;
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isValidIdentifier(String string, String string2) throws UnsupportedEncodingException {
        if (M_C_UNICODE_CHARSETS.contains(string2.toUpperCase(Locale.US))) {
            return true;
        }
        String string3 = OraBoot.getInstance().getCharSetId(string2);
        if (string3 == null) {
            return false;
        }
        int n = Integer.parseInt(string3);
        try {
            CharacterConverterOGS.getInstance(n).toOracleString(string);
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    static {
        M_C_UNICODE_CHARSETS.add("UTF8");
        M_C_UNICODE_CHARSETS.add("AL32UTF8");
        M_C_UNICODE_CHARSETS.add("AL16UTF16");
        M_C_UNICODE_CHARSETS.add("AL16UTF16LE");
        M_C_UNICODE_CHARSETS.add("UTFE");
        charEntity = OraMapTable.getInstance(6).getHashMapAttribute("CHAR_ENTITY_REFERENCE");
        resCharEntities = new HashMap(5);
        resCharEntities.put(new Character('<'), "&lt;");
        resCharEntities.put(new Character('>'), "&gt;");
        resCharEntities.put(new Character('&'), "&amp;");
        resCharEntities.put(new Character('\''), "&apos;");
        resCharEntities.put(new Character('\"'), "&quot;");
    }

    public static class Form {
        private static int m_nextOrdinal = 0;
        public static final Form NAMED = new Form("Named entity");
        public static final Form DECIMAL_NUMBER = new Form("Decimal number entity");
        public static final Form HEXADECIMAL_NUMBER = new Form("Hexadecimal number entity");
        public static final Form NAMED_HEXADECIMAL_NUMBER = new Form("Named entity");
        public static final Form NAMED_DECIMAL_NUMBER = new Form("Decimal number entity");
        private final int m_ordinal = m_nextOrdinal++;
        private final String name;

        private Form(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public static final int size() {
            return m_nextOrdinal;
        }
    }
}

